
<?php

use Illuminate\Support\Facades\Auth;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\VehicleController;
use App\Http\Controllers\VehicleBrandController;
use App\Http\Controllers\VehicleTypeController;
use App\Http\Controllers\FareController;
use App\Http\Controllers\PaymentMethodController;
use App\Http\Controllers\PrepaidCardController;
use App\Http\Controllers\TakingsController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\WorkstationController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\TurnController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\AnsapassController;
use App\Http\Controllers\DocumentTypeController;
use App\Http\Controllers\PrepaidSummaryController;
use App\Http\Controllers\BankAccountController;
use App\Http\Controllers\SalePointController;
use App\Http\Controllers\ProfileTypeController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\VoltaController;


Route::post('login', [AuthController::class, 'authenticate']);
Route::get('/read/tag/{tag}', [AnsapassController::class, 'readTag'])->middleware('checkAnsapass');
Route::get('test/server', [AuthController::class, 'testServer']);
Route::post('workstations',        [WorkstationController::class, 'index']);
Route::post('workstations/update', [WorkstationController::class, 'update']);

Route::get('ansapass/last/processed',  [AnsapassController::class, 'lastProcessed']);

Route::group(['middleware' => 'auth:sanctum'], function () {
	Route::post('logout', [AuthController::class, 'logout']);

	Route::post('users',                   [ProfileController::class, 'index']);
	Route::post('users/search',            [ProfileController::class, 'search']);
	Route::post('users/save',              [ProfileController::class, 'save']);
	Route::post('users/vehicles/get',      [ProfileController::class, 'getVehicles']);
	Route::post('users/prepaid/cards/get', [ProfileController::class, 'getPrepaidCards']);
	Route::post('users/delete',            [ProfileController::class, 'delete']);
	Route::post('users/workers',           [ProfileController::class, 'workers']);

	Route::post('prepaid/cards',                  [PrepaidCardController::class, 'index']);
	Route::post('prepaid/cards/generate',         [PrepaidCardController::class, 'generatePrepaidCard']);
	Route::post('prepaid/cards/change/password',  [PrepaidCardController::class, 'changePassword']);
	Route::post('prepaid/cards/make/recharge',    [PrepaidCardController::class, 'makeRecharge']);
	Route::post('prepaid/cards/search',           [PrepaidCardController::class, 'search']);
	Route::post('prepaid/cards/validate/password',[PrepaidCardController::class, 'validatePassword']);
	Route::post('prepaid/cards/delete',           [PrepaidCardController::class, 'delete']);
	Route::post('prepaid/cards/print',            [PrepaidCardController::class, 'printPrepaidCard'])->middleware('auth:sanctum');
	Route::post('prepaid/cards/toggle/direct',    [PrepaidCardController::class, 'toggleDirect']);
	Route::post('prepaid/cards/toggle/status',    [PrepaidCardController::class, 'toggleStatus']);
	Route::post('prepaid/cards/get/vehicles',     [PrepaidCardController::class, 'getVehicles']);
	Route::post('prepaid/cards/update/vehicle',   [PrepaidCardController::class, 'updateVehicle']);

	// Temporal route
	Route::post('prepaid/card/validate/password',[PrepaidCardController::class, 'validatePassword']);
	Route::post('prepaid/card/search',           [PrepaidCardController::class, 'search']);
	// END Temporal route

	Route::post('vehicles',        	 	  [VehicleController::class, 'index']);
	Route::post('vehicles/search', 		  [VehicleController::class, 'search']);
	Route::post('vehicles/save',   		  [VehicleController::class, 'save']);
	Route::post('vehicles/delete', 	   	  [VehicleController::class, 'delete']);
	Route::post('vehicles/toggle/status', [VehicleController::class, 'toggleStatus']);

	Route::get('brands',            [VehicleBrandController::class, 'index']);
	Route::post('vehicle/brands',   [VehicleBrandController::class, 'all']);
	Route::post('vehicle/types',    [VehicleTypeController::class, 'all']);

	Route::post('document/types', [DocumentTypeController::class, 'all']);

	Route::get('payment/methods', [PaymentMethodController::class, 'index'])->middleware('auth:sanctum');

	Route::post('takings/make', [TakingsController::class, 'makeTakings'])->middleware(['checkIp']);

	Route::post('turns/search',       [TurnController::class, 'searchTurn']);
	Route::get('turns', 	   		  [TurnController::class, 'index']);
	Route::get('turns/activeTurns',	  [TurnController::class, 'activeTurns']);
	Route::post('turns/show',  		  [TurnController::class, 'show']);
	Route::post('turns/close', 		  [TurnController::class, 'closeTurn']);
	Route::post('turns/last/takings', [TurnController::class, 'lastTakings']);

	Route::post('ansapass', 			  [AnsapassController::class, 'index']);
	Route::post('ansapass/create', 		  [AnsapassController::class, 'create']);
	Route::post('ansapass/delete', 	 	  [AnsapassController::class, 'delete']);
	Route::post('ansapass/toggle/status', [AnsapassController::class, 'toggleStatus']);
	Route::post('ansapass/last/processed',  [AnsapassController::class, 'lastProcessed']);

	Route::post('reports/diary/summary',        [ReportController::class, 'diarySummaryReport']);
	Route::post('reports/print/diary/summary',  [ReportController::class, 'printDiarySummaryReport']);
	Route::post('reports/print/working/day',    [ReportController::class, 'printWorkingDay']);
	Route::post('reports/get/prepaid/summary',  [ReportController::class, 'getPrepaidSummaryReport']);
	Route::post('reports/print/prepaid/summary',[ReportController::class, 'printPrepaidSummaryReport']);
	Route::post('reports/recover/turn/summary', [ReportController::class, 'recoverturnSummary']);

	Route::post('prepaid/summary/cancel',        [PrepaidSummaryController::class, 'cancelRecharge']);

	Route::post('banks',                [BankAccountController::class, 'banks']);
	Route::post('bank/accounts',        [BankAccountController::class, 'index']);
	Route::post('bank/accounts/all',    [BankAccountController::class, 'all']);
	Route::post('bank/accounts/add',    [BankAccountController::class, 'save']);
	Route::post('bank/accounts/search', [BankAccountController::class, 'search']);
	Route::post('bank/accounts/delete', [BankAccountController::class, 'delete']);

	Route::post('sale/points',        [SalePointController::class, 'index']);
	Route::post('sale/points/add',    [SalePointController::class, 'save']);
	Route::post('sale/points/delete', [SalePointController::class, 'delete']);

	Route::post('fares',        [FareController::class, 'index'])->middleware('auth:sanctum');
	Route::post('fares/add',    [FareController::class, 'save']);
	Route::post('fares/search', [FareController::class, 'search']);
	Route::post('fares/all',    [FareController::class, 'all']);

	Route::post('dashboard/getSummary',    [DashboardController::class, 'index']);

	Route::post('volta/get',    [VoltaController::class, 'search']);
	Route::post('volta/save',    [VoltaController::class, 'create']);
	Route::post('volta/close',    [VoltaController::class, 'reconcile']);
	Route::post('volta/report',    [VoltaController::class, 'getReport']);

	Route::post('profile/types/all',    [ProfileTypeController::class, 'all']);
});