<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>SIGEP | Reporte de Recaudaciones</title>

        <!-- Fonts -->
        {{-- <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet"> --}}
        <link href="{{ asset('build/assets/app.css') }}" rel="stylesheet">

        <script src="{{ asset('assets/loader.js') }}"></script>
        <script>
            function init() {
                google.charts.load("visualization", "44", {packages: ['corechart']});
                var interval = setInterval(function () {
                    if (google.visualization !== undefined && google.visualization.DataTable !== undefined && google.visualization.PieChart !== undefined) {
                        clearInterval(interval);
                        window.status = 'ready';
                        drawVehicleTypeChart();
                        drawVehicleAmmountChart();
                        drawPaymentMethodsChart();
                    }
                }, 100);
            }

            function drawVehicleTypeChart() {

                var data = google.visualization.arrayToDataTable([
                    ['Tipo', 'Cantidad'],
                    ['Livianos',     {{ $data->vehicleType['1'] }}],
                    ['Micro Bus',      {{ $data->vehicleType['2'] }}],
                    ['Camion 350',  {{ $data->vehicleType['3'] }}],
                    ['Camion 750', {{ $data->vehicleType['4'] }}],
                    ['Camion 3 Ejes',    {{ $data->vehicleType['5'] }}],
                    ['Camion 4 Ejes',    {{ $data->vehicleType['6'] }}],
                    ['Camion 5 Ejes',    {{ $data->vehicleType['7'] }}],
                    ['Camion 6 Ejes',    {{ $data->vehicleType['8'] }}],
                    ['Expresos',    {{ $data->vehicleType['9'] }}]
                    ]);

                var options = {
                    chartArea:{width:"80%",height:"60%"},
                    legend: { position: 'left', alignment: 'center' },
                    width: 500,
                    height: 450,
                    backgroundColor: '#f1e9ca',
                    legend: 'labeled',
                    pieSliceText: 'none',
                    pieStartAngle: 120,
                };

                var chart = new google.visualization.PieChart(document.getElementById('vehicleTypeChart'));

                chart.draw(data, options);
            }

            function drawVehicleAmmountChart() {
                var data = google.visualization.arrayToDataTable([
                    ['Tipo', 'Cantidad'],
                    ['Livianos',     {{ $data->vehicleTypeAmount['1'] }}],
                    ['Micro Bus',      {{ $data->vehicleTypeAmount['2'] }}],
                    ['Camion 350',  {{ $data->vehicleTypeAmount['3'] }}],
                    ['Camion 750', {{ $data->vehicleTypeAmount['4'] }}],
                    ['Camion 3 Ejes',    {{ $data->vehicleTypeAmount['5'] }}],
                    ['Camion 4 Ejes',    {{ $data->vehicleTypeAmount['6'] }}],
                    ['Camion 5 Ejes',    {{ $data->vehicleTypeAmount['7'] }}],
                    ['Camion 6 Ejes',    {{ $data->vehicleTypeAmount['8'] }}],
                    ['Expresos',    {{ $data->vehicleTypeAmount['9'] }}]
                    ]);

                var options = {
                    chartArea:{width:"80%",height:"60%"},
                    legend: { position: 'left', alignment: 'center' },
                    width: 500,
                    height: 450,
                    backgroundColor: '#f1e9ca',
                    legend: 'labeled',
                    pieSliceText: 'none'
                };

                var chart = new google.visualization.PieChart(document.getElementById('vehicleAmmountChart'));

                chart.draw(data, options);
            }

            function drawPaymentMethodsChart() {
                var data = google.visualization.arrayToDataTable([
                    ['Tipo', 'Monto'],
                    ['Efectivo',     {{ $data->paymentMethod['1'] }}],
                    ['Debito',      {{ $data->paymentMethod['2'] }}],
                    ['Credito',  {{ $data->paymentMethod['3'] }}],
                    ['Transferencia', {{ $data->paymentMethod['4'] }}],
                    ['Pago Movil',    {{ $data->paymentMethod['5'] }}],
                    ['Sistema Prepago',    {{ $data->paymentMethod['6'] }}]
                    ]);

                var options = {
                    chartArea:{width:"80%",height:"60%"},
                    legend: { position: 'left', alignment: 'center' },
                    width: 500,
                    height: 450,
                    legend: 'labeled',
                    pieSliceText: 'none',
                    backgroundColor: '#fcd6b7'
                };

                var chart = new google.visualization.PieChart(document.getElementById('paymentMethodsChart'));

                chart.draw(data, options);
            }
        </script>

    </head>
    <body onload="init()" style="padding: 0 !important; max-width: 1700px;">
        <div class="box">
            <div class="flex flex-row p-1 text-center flex-wrap"  style="background-color: #929292;">
                <table class="w-full">
                    <thead>
                        <tr>
                            <th>
                                <img src="{{ asset('assets/gobernacion.png') }}" style="max-height: 70px; margin-left: 20px;">
                            </th>
                            <th>
                                <h1 class="text-2xl" style="color: #fff;">
                                    Reporte de Cierre Diario {{ $data->fromDate }} hasta {{ $data->toDate }}
                                </h1>
                            </th>
                            <th>
                                <img src="{{ asset('assets/ansa-logo.png') }}" class="ml-auto mr-20" style="max-height: 100px; margin-right: 30px;">
                            </th>
                        </tr>
                    </thead>
                </table>
            </div>
            <div class="flex flex-row border-b px-5 py-10 text-center ">
                <table class="w-full">
                    <thead>
                        <tr>
                            <th class="whitespace-nowrap">
                                <div class="text-2xl text-primary font-medium mt-2">Peaje el Cardenalito</div>
                            </th>
                            <th class="whitespace-nowrap">
                                <div class="mt-1 text-sm">Fecha: {{ date('d-m-Y H:i:s') }}</div>
                            </th>
                        </tr>
                    </thead>
                </table>
            </div>
            <div class="flex flex-row border-b px-5 py-2 text-center ">
                <table class="w-full">
                    <tbody>
                        <tr>
                            <td class="whitespace-nowrap px-32" colspan="2" style="background-color: #f1e9ca;">
                                <h1 class="text-2xl"  style="margin: 10px 0;">
                                    Recaudación por Tipo de Vehiculo
                                </h1>
                                <div class="overflow-x-auto">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th class="border-b-2 whitespace-nowrap text-left"> Tipo de Vehículo </th>
                                                <th class="border-b-2 whitespace-nowrap text-center"> Cantidad </th>
                                                <th class="border-b-2 whitespace-nowrap text-center"> Monto Bs </th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-base">
                                            <tr style="background-color: #ebdb9f;">
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> Liviano </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right w-32">
                                                    {{ $data->vehicleType['1'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleType['1'] * 100 / $data->totalVehicles), 2)  }} %
                                                    </span>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right w-32">
                                                    {{ $data->vehicleTypeAmount['1'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleTypeAmount['1'] * 100 / $data->totalPayments), 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> Micro Bus </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleType['2'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleType['2'] * 100 / $data->totalVehicles), 2)  }} %
                                                    </span>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleTypeAmount['2'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleTypeAmount['2'] * 100 / $data->totalPayments), 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr style="background-color: #ebdb9f;">
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> Camión 350 </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleType['3'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleType['3'] * 100 / $data->totalVehicles), 2)  }} %
                                                    </span>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleTypeAmount['3'] }} ==>
                                                     <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleTypeAmount['3'] * 100 / $data->totalPayments), 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> Camión 750 </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleType['4'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleType['4'] * 100 / $data->totalVehicles), 2)  }} %
                                                    </span>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleTypeAmount['4'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleTypeAmount['4'] * 100 / $data->totalPayments), 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr style="background-color: #ebdb9f;">
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> Camión 3 Ejes </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleType['5'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleType['5'] * 100 / $data->totalVehicles), 2)  }} %
                                                    </span>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleTypeAmount['5'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleTypeAmount['5'] * 100 / $data->totalPayments), 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> Camión 4 Ejes </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleType['6'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleType['6'] * 100 / $data->totalVehicles), 2)  }} %
                                                    </span>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleTypeAmount['6'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleTypeAmount['6'] * 100 / $data->totalPayments), 2)  }} %
                                                    </span>
                                                </td>>
                                            </tr>
                                            <tr style="background-color: #ebdb9f;">
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> Camión 5 Ejes </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleType['7'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleType['7'] * 100 / $data->totalVehicles), 2)  }} %
                                                    </span>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleTypeAmount['7'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleTypeAmount['7'] * 100 / $data->totalPayments), 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> Camión 6 Ejes </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleType['8'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleType['8'] * 100 / $data->totalVehicles), 2)  }} %
                                                    </span>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleTypeAmount['8'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleTypeAmount['8'] * 100 / $data->totalPayments), 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr style="background-color: #ebdb9f;">
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> Autobus Expreso </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleType['9'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleType['9'] * 100 / $data->totalVehicles), 2)  }} %
                                                    </span>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->vehicleTypeAmount['9'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->vehicleTypeAmount['9'] * 100 / $data->totalPayments), 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> TOTAL </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->totalVehicles }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(100, 2)  }} %
                                                    </span>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->totalPayments }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(100, 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </td >
                            <td class="whitespace-nowrap align-sub" style="background-color: #fcd6b7; padding: 0 20px;">
                                <h1 class="text-2xl" style="margin: 10px 0;">
                                    Recaudación por Formas de Pago
                                </h1>
                                <div class="overflow-x-auto">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th class="border-b-2 whitespace-nowrap"> Forma de Pago </th>
                                                <th class="border-b-2 text-right whitespace-nowrap"> Monto Bs </th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-base">
                                            <tr style="background-color: #fec291;">
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> Efectivo </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->paymentMethod['1'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->paymentMethod['1'] * 100 / $data->totalPayments), 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> Debito </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->paymentMethod['2'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->paymentMethod['2'] * 100 / $data->totalPayments), 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr style="background-color: #fec291;">
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> Credito </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->paymentMethod['3'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->paymentMethod['3'] * 100 / $data->totalPayments), 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> Transferencia </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->paymentMethod['4'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->paymentMethod['4'] * 100 / $data->totalPayments), 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr style="background-color: #fec291;">
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> Pago Movil </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->paymentMethod['5'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->paymentMethod['5'] * 100 / $data->totalPayments), 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> Sistema Prepago </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->paymentMethod['6'] }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(($data->paymentMethod['6'] * 100 / $data->totalPayments), 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr style="background-color: #fec291;">
                                                <td style="padding: 2px 15px;" class="border-b">
                                                    <div class="font-medium whitespace-nowrap"> TOTAL </div>
                                                </td>
                                                <td style="padding: 2px 15px;" class="text-right border-b w-32">
                                                    {{ $data->totalPayments }} ==>
                                                    <span style="color: #d97c0f;">
                                                        {{ number_format(100, 2)  }} %
                                                    </span>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td class="whitespace-nowrap" style="background-color: #f1e9ca;">
                                <div id="vehicleTypeChart"></div>
                                <h2 class="text-center text-lg">
                                    Grafico de Vehiculo por Cantidad
                                </h2>
                            </td>
                            <td class="whitespace-nowrap" style="background-color: #f1e9ca  ;">
                                <div id="vehicleAmmountChart"></div>
                                <h2 class="text-center text-lg">
                                    Grafico de Vehiculo por Monto En Bs
                                </h2>
                            </td>
                            <td class="whitespace-nowrap" style="background-color: #fcd6b7;">
                                <div id="paymentMethodsChart"></div>
                                <h2 class="text-center text-lg">
                                    Grafico de Formas de Pago
                                </h2>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="flex flex-row px-5 pt-4 text-center">
                <div id="piechart"></div>
            </div>
        </div>
    </body>
</html>
