<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\VehicleType;

class VehicleTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $file = file_get_contents('database/seeders/data/vehicle-types.json');
        $json = json_decode($file);

        foreach ($json as $type) {
            VehicleType::create([
                'id' => $type->id,
                'name' => $type->name,
                'description' => $type->description,
                'image' => $type->image,
            ]);
        }
    }
}
