<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Payment;
use App\Models\Takings;

class RecoverLastRegistersBeforeChangeServerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // $file = file_get_contents('database/seeders/data/last-takings.json');
        // $json = json_decode($file);
        $changeTurn = [];
        $changeTurn[83] = 89;
        $changeTurn[84] = 87;
        $changeTurn[85] = 88;
        $changeTurn[86] = 90;

        $increment = 2000;

        $takings = Takings::with('payments')->where("id", ">=", 41716)->get();

        foreach ($takings as $t) {
            echo $t->code."|".$changeTurn[$t->turn_id]."|".$t->vehicle_type_id."|".($t->vehicle_id ?? "-" )."|".$t->amount."|".$t->created_at."|".$t->updated_at."|".($t->payments[0]->last_digits?? "-" )."|".$t->payments[0]->payment_method_id."|".$t->payments[0]->amount."|".$t->payments[0]->created_at."|".$t->payments[0]->updated_at.PHP_EOL;
        }
    }
}
