<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\PrepaidCard;
use App\Models\Vehicle;
use App\Models\User;
use App\Models\Profile;
use App\Models\DocumentType;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;

class PrepaidCardSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $file = file_get_contents('database/seeders/data/prepaid-cards-imported-2.json');
        $json = json_decode($file);

        // Document Types
        $v = DocumentType::where('letter', 'V')->first();
        $e = DocumentType::where('letter', 'E')->first();
        $j = DocumentType::where('letter', 'J')->first();
        $g = DocumentType::where('letter', 'G')->first();

        $index = 0;
        $total = count($json);

        foreach ($json as $item) {
            // Define Document Type
            $firstLetter = strtoupper(substr($item->idCard, 0, 1));
            $documentType = $v;
            if ($firstLetter == 'J') {
                $documentType = $j;
            } else if ($firstLetter == 'G') {
                $documentType = $g;
            } else if ($firstLetter == 'E') {
                $documentType = $e;
            }

            $idCard = $this->sanitizeNumber($item->idCard);

            $profile = Profile::where('document_type_id', $documentType->id)
                            ->where('id_card', $idCard)
                            ->first();

            if (!$profile){
                print($documentType->letter.$idCard . ' not found') . PHP_EOL;
                $profile = Profile::find(1);
            }
            $card = PrepaidCard::create([
                'profile_id' => $profile->id,
                'code' => $item->code,
                'password' => $item->password,
                // 'password' => Hash::make($item->password),
                'balance' => $item->balance,
                // 'exonerated' => $item->exonerated,
                'exonerated' => 0,
                'status' => $item->status,
                // 'created_at'=> strtotime($item->createdAt),
                'created_at'=> now(),
            ]);

            $this->printProgress($total, $index);
            $index++;
        }
    }

    private function sanitizeNumber(string $number): string
    {
        $charsToClean = ['V', 'G', 'J', 'E', ' ', ',', '.', '-'];
        return str_replace($charsToClean, '', strtoupper($number));
    }

    private function formatWords(string $word): string
    {
        $wordFormated = ucwords(strtolower($word));
        $wordFormated = str_replace(' S.a.c.a.', ' S.A.C.A.', $wordFormated);
        $wordFormated = str_replace(' C.a.', ' C.A.', $wordFormated);
        $wordFormated = str_replace(' S.a.', ' S.A.', $wordFormated);
        return $wordFormated;
    }

    private function cleanAddress(string $word): string
    {
        return ucfirst(strtolower($word));
    }

    private function printProgress($total, $index): void
    {
        // Print progress every $steps%
        $steps = 50;
        $ratio = 50;
        $progress = round($index * 100 * $ratio / $total);
        if ( $progress % $steps == 0 ) {
            print('....'. ($progress / $ratio) .'%');
        }
        if($total == ($index + 1)) {
            print(PHP_EOL. PHP_EOL. '      FINISHED!!' . PHP_EOL. PHP_EOL);
        }
    }
}
