<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\PaymentMethod;

class PaymentMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $file = file_get_contents('database/seeders/data/payment-methods-imported.json');
        $json = json_decode($file);

        foreach ($json as $item) {
            PaymentMethod::create([
                'name' => $item->name,
                'description' => $item->description,
                'image' => $item->image,
            ]);
        }
    }
}
