<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Fare;

class FareSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $file = file_get_contents('database/seeders/data/fares-imported.json');
        $json = json_decode($file);

        foreach ($json as $item) {
            Fare::create([
                'vehicle_type_id' => $item->vehicleTypeId,
                'name' => $item->name,
                'value' => $item->value,
            ]);
        }
    }
}
