<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Payment;
use App\Models\Takings;

class ExecuteLastImportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $file = file_get_contents('database/seeders/data/last-data-to-import.json');
        $json = json_decode($file);


        foreach ($json as $key => $item) {
            $taking = Takings::create([
                "code" => $item->code,
                "turn_id" => $item->turnId,
                "vehicle_type_id" => $item->vehicleTypeId,
                "vehicle_id" => $item->vehicleId,
                "amount" => $item->takingAmount,
                "created_at" => $item->takingCreatedAt,
                "updated_at" => $item->takingUpdatedAt,
            ]);

            $payment = Payment::create([
                "last_digits" => $item->lastDigits,
                "payment_method_id" => $item->paymentMethodId,
                "amount" => $item->amount,
                "created_at" => $item->createdAt,
                "updated_at" => $item->updatedAt,
            ]);

            $taking->payments()->attach($payment);
        }
    }
}
