<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\DocumentType;

class DocumentTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $file = file_get_contents('database/seeders/data/document_types.json');
        $json = json_decode($file);

        foreach ($json as $item) {
            DocumentType::create([
                'letter' => $item->letter,
                'name' => $item->name
            ]);
        }
    }
}
