<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Turn;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // \App\Models\User::factory(10)->create();

        // \App\Models\User::factory()->create([
        //     'name' => 'Test User',
        //     'email' => 'test@example.com',
        // ]);

        // Light Sedeers
        $this->call(VehicleBrandSeeder::class);
        $this->call(VehicleTypeSeeder::class);
        $this->call(DocumentTypeSeeder::class);
        $this->call(WorkstationSeeder::class);
        $this->call(ProfileTypeSeeder::class);
        $this->call(FareSeeder::class);
        $this->call(PaymentMethodSeeder::class);

        // Heavy Seeders
        $this->call(ProfileClientsSeeder::class);
        $this->call(ProfileWorkersSeeder::class);
        $this->call(PrepaidCardSeeder::class);
        $this->call(VehicleSeeder::class);
        $this->call(AnsaPassSeeder::class);

        Turn::create([
            "profile_id" => 1,
            "workstation_id" => 1,
            "number" => 4000,
            "begin_at" => now(),
            "end_at" => now()
        ]);

        // $this->call(TurnosSeeder::class);
        // $this->call(RecaudacionesSeeder::class);
        /**
         * Aditional Functions
         */

        $this->call(UpdateCollectorPasswords::class);
        // $this->call(HashingPasswordCards::class);
    }
}

