<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTakingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::disableForeignKeyConstraints();

        Schema::create('takings', function (Blueprint $table) {
            $table->id();
            $table->string('code', 20);
            $table->foreignId('turn_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->foreignId('vehicle_type_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->foreignId('vehicle_id')->nullable()->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->decimal('amount', 8, 2);
            $table->timestamps();
        });

        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('takings');
    }
}
