<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePrepaidSummariesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::disableForeignKeyConstraints();

        Schema::create('prepaid_summaries', function (Blueprint $table) {
            $table->id();
            $table->foreignId('prepaid_card_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->foreignId('ansapass_id')->nullable()->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('code', 20);
            $table->enum('type', ["add","out"]);
            $table->string('concept', 100);
            $table->decimal('amount', 8, 2);
            $table->decimal('tax', 8, 2)->default(0);
            $table->timestamps();
        });

        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prepaid_summaries');
    }
}
