<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProfilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::disableForeignKeyConstraints();

        Schema::create('profiles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->foreignId('document_type_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('id_card', 12);
            $table->foreignId('profile_type_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('names', 50);
            $table->string('surnames', 50)->nullable();
            $table->string('phone', 13)->nullable();
            $table->string('address', 200)->nullable();
            $table->timestamps();
        });

        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('profiles');
    }
}
