<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\Profile;
use App\Models\Vehicle;
use App\Models\VehicleBrand;
use App\Models\VehicleType;

class VehicleFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Vehicle::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'plate' => $this->faker->regexify('[A-Za-z0-9]{10}'),
            'profile_id' => Profile::factory(),
            'vehicle_type_id' => VehicleType::factory(),
            'vehicle_brand_id' => VehicleBrand::factory(),
            'year' => $this->faker->numberBetween(-10000, 10000),
            'color' => $this->faker->regexify('[A-Za-z0-9]{20}'),
            'deleted_at' => $this->faker->dateTime(),
        ];
    }
}
