<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\Takings;
use App\Models\Turn;
use App\Models\Vehicle;
use App\Models\VehicleType;

class TakingsFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Takings::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'code' => $this->faker->regexify('[A-Za-z0-9]{20}'),
            'turn_id' => Turn::factory(),
            'vehicle_type_id' => VehicleType::factory(),
            'vehicle_id' => Vehicle::factory(),
            'amount' => $this->faker->randomFloat(2, 0, 999999.99),
        ];
    }
}
