<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\DocumentType;
use App\Models\Profile;
use App\Models\ProfileType;
use App\Models\User;

class ProfileFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Profile::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'user_id' => User::factory(),
            'document_type_id' => DocumentType::factory(),
            'id_card' => $this->faker->regexify('[A-Za-z0-9]{12}'),
            'profile_type_id' => ProfileType::factory(),
            'names' => $this->faker->regexify('[A-Za-z0-9]{50}'),
            'surnames' => $this->faker->regexify('[A-Za-z0-9]{50}'),
            'phone' => $this->faker->phoneNumber,
            'address' => $this->faker->regexify('[A-Za-z0-9]{200}'),
        ];
    }
}
