<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\PrepaidCard;
use App\Models\Profile;

class PrepaidCardFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = PrepaidCard::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'profile_id' => Profile::factory(),
            'code' => $this->faker->regexify('[A-Za-z0-9]{24}'),
            'password' => $this->faker->password,
            'balance' => $this->faker->randomFloat(2, 0, 999999.99),
            'exonerated' => $this->faker->boolean,
            'direct' => $this->faker->boolean,
            'status' => $this->faker->boolean,
            'deleted_at' => $this->faker->dateTime(),
        ];
    }
}
