<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\DocumentType;

class DocumentTypeFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = DocumentType::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'letter' => $this->faker->regexify('[A-Za-z0-9]{1}'),
            'name' => $this->faker->name,
            'deleted_at' => $this->faker->dateTime(),
        ];
    }
}
