<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\Ansapass;
use App\Models\PrepaidCard;
use App\Models\Vehicle;

class AnsapassFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Ansapass::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'code' => $this->faker->regexify('[A-Za-z0-9]{24}'),
            'prepaid_card_id' => PrepaidCard::factory(),
            'vehicle_id' => Vehicle::factory(),
            'deleted_at' => $this->faker->dateTime(),
        ];
    }
}
