<?php

namespace App\Traits;

use stdClass;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Pagination\LengthAwarePaginator;

/*
|--------------------------------------------------------------------------
| Api Responser Trait
|--------------------------------------------------------------------------
|
| This trait will be used for any response we sent to clients.
|
*/

trait PaginatorHelper
{
	private $defaultSize = 10;

	protected function processRequest(Request $request): stdClass
	{
		$helper = new \stdClass();
		$helper->page 	 = intval($request->page ?? 1);
		$helper->size 	 = intval($request->size ?? $this->defaultSize);
		$helper->filter  = ($request->filter) ? $request->filter : null;
		$helper->include = ($request->include) ? explode(',', $request->include) : null;
		$helper->fields  = ($request->fields) ? explode(',', $request->fields) : ['*'];
		$helper->sort 	 = ($request->sort) ? $this->convertStringSort($request->sort) : null;

		return $helper;
	}

	private function convertStringSort($sort): array
	{
		$arraySort = [];
		$sortBy = ($sort) ? explode(',', $sort) : [];
		foreach ($sortBy as $sort) {
			$field = str_replace('-', '', $sort);
			$order = str_starts_with($sort, '-') ? 'desc' : 'asc';
			$item = new \stdClass();
			$item->field = $field;
			$item->order = $order;
			$arraySort[] = $item;
		}

		return $arraySort;
	}

	public function applyFilters(Builder $builder, stdClass $helper, array $fieldToFilter = []): LengthAwarePaginator
	{
		if ($helper->include && count($helper->include)) {
			$includes = [];
			foreach ($helper->include as $include) {
				$includes[] = $include;
			}
			$builder->with($includes);
		}

		if (count($fieldToFilter) && $helper->filter) {
			$search = $helper->filter;
			$array = $fieldToFilter;
			$builder->Where(function ($query) use ($array, $search) {
				foreach ($array as $value) {
					if (strpos($value, '.', 1)) {
						$detail = explode('.', $value);
						$table = $detail[0];
						$fields = explode(',', $detail[1]);
						$query->orWhereHas($table, function ($q) use ($fields, $search) {
							$cont2 = 0;
							foreach ($fields as $field) {
								if ($cont2 == 0) {
									$q->where($field, 'like', '%'.$search.'%');
								} else {
									$q->orWhere($field, 'like', '%'.$search.'%');
								}
								$cont2++;
							}
						});
					} else {
						$query->orWhere($value, 'like', '%'.$search.'%');
					}
				}
			});
		}

		if ($helper->sort && count($helper->sort)) {
			foreach ($helper->sort as $sort) {
				$builder->orderBy($sort->field, $sort->order);
			}
		}

		$rows = $builder->paginate($helper->size, $helper->fields, 'page', $helper->page);
		$rows->appends(request()->query());
		return $rows;
	}

}
