<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VehicleType extends Model
{
    use HasFactory;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'deleted_at' => 'timestamp',
    ];

    public function vehicles()
    {
        return $this->hasMany(Vehicle::class);
    }

    public function takings()
    {
        return $this->hasMany(Takings::class);
    }

    public function fare()
    {
        return $this->hasOne(Fare::class);
    }
}
