<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Turn extends Model
{
    use HasFactory;
    use SoftDeletes;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'profile_id' => 'integer',
        'workstation_id' => 'integer',
        'begin_at' => 'timestamp',
        'end_at' => 'timestamp',
        'voltaCheck' => 'boolean',
    ];

    public function takings()
    {
        return $this->hasMany(Takings::class);
    }

    public function profile()
    {
        return $this->belongsTo(Profile::class);
    }

    public function workstation()
    {
        return $this->belongsTo(Workstation::class);
    }

    public function volta()
    {
        return $this->hasMany(Volta::class);
    }
}
