<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Takings extends Model
{
    use HasFactory;
    use SoftDeletes;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'turn_id' => 'integer',
        'vehicle_type_id' => 'integer',
        'vehicle_id' => 'integer',
        'amount' => 'decimal:2',
    ];

    public function payments()
    {
        return $this->morphToMany(Payment::class, 'paymentable');
    }

    public function turn()
    {
        return $this->belongsTo(Turn::class);
    }

    public function vehicleType()
    {
        return $this->belongsTo(VehicleType::class);
    }

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }
}
