<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Workstation;

class WorkstationController extends Controller
{
    public function index()
    {
        $workstations = Workstation::all();
        return response()->json($workstations);
    }

    public function update(Request $request)
    {
        $workstation = Workstation::find($request->workstation_id);
        if(!$workstation) {
            return response()->json([
                "status" => 0,
                "message" => "Estacion de trabajo no registrada en la base de datos"
            ]);
        }

        $workstation->printer = $request->printerName;
        $workstation->save();
        return response()->json([
            "status" => 1,
            "workstation" => $workstation,
            "message" => "Datos registrados exitosamente"
        ]);
    }

    public function delete(Request $request)
    {
        $id = $request->id;
        try{
            $workstation = Workstation::find($id);
            $workstation->delete();
            return response()->json([
                "status" => 1,
                "message" => "Estacion de trabajo ". $workstation->name . " eliminado exitosamente"
            ]);

        } catch (\Exception $e) {
            return response()->json([
                "status" => 0,
                "message" => "Ocurrio un error, intente mas tarde, si el problema persiste comuniquese con su administrador"
            ]);
        }
    }
}
