<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\Turn;
use App\Models\Volta;


class VoltaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
   

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function search(Request $request)
    {
        $number = $request->number;
           $data = Turn::with(['volta', 'profile', 'workstation'])
                ->where('number', $number)
                ->whereHas('takings.payments', function ($query) {
                    $query->where('payment_method_id', 1);
                })
                ->withSum(['takings' => function ($query) {
                    $query->whereHas('payments', function ($q) {
                        $q->where('payment_method_id', 1);
                    });
                }], 'amount')
                ->first();



        if ($data !== null) {
            $data->takings_sum_amount = $data->takings_sum_amount ?? 0;
             $data->valid = true;
        } else {
            $data = (object) ['takings_sum_amount' => 0,'valid'=>false];
        }

        return response()->json($data);
    }

    public function getReport(Request $request)
    {
        $from = $request->from;
        $to = $request->to;
        $data = Volta::with(['turn'])
                        ->whereDate('created_at', '>=', $from)
                        ->whereDate('created_at','<=', $to)
                        ->get();
        return response()->json($data);
    }

    public function reconcile(Request $request)
    {
        $turn = Turn::find($request->turn_id);
        $turn->voltaCheck = true;
        $turn->save();
        if($turn) {
            return response()->json([
                "status" => 1,
                "message" => "Conciliacion correcta"
            ]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $volta = new Volta();
        $volta->turn_id = $request->turn_id;
        $volta->collected = $request->collected;
        $volta->received = $request->received;
        $volta->note = $request->note;
        $volta->income = $request->income;
        $volta->create_by = "Admin";

        try {
            $volta->save();
            return response()->json([
                "status" => 1,
                "message" => "Registro Guardado"
            ]);
        } catch (Exception $e) {
            return response()->json([
                "status" => 0,
                "message" => "Ocurrio un error en el servidor, intente mas tarde"
            ]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
