<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\BankAccount;
use App\Models\SalePoint;
use App\Traits\PaginatorHelper;
use Illuminate\Support\Facades\DB;


class SalePointController extends Controller
{
    use PaginatorHelper;

    public function index(Request $request)
    {
        $helper = $this->processRequest($request);
        $salePoints = SalePoint::whereNotNull('id');
        $salePoints->with('bankAccount.bank');
        $salePoints = $this->applyFilters($salePoints, $helper, ['name']);

        return response()->json($salePoints);
    }

    public function save(Request $request)
    {
        $id = $request->id;

        try{
            // Begin of the transaction
            DB::beginTransaction();
            if ($id) {
                $salePoint = SalePoint::find($id);
            } else {
                $salePoint = new SalePoint();
            }

            $salePoint->name = $request->name;
            $salePoint->bank_account_id = $request->bankAccountId;

            $salePoint->save();

            // Write in the database
            DB::commit();
            if ($salePoint) {
                return response()->json([
                    "status" => 1,
                    "item" => $salePoint,
                    "message" => "Punto de Venta actualizada exitosamente"
                ]);
            } else {
                return response()->json([
                    "status" => 0,
                    "message" => "Punto de Venta No encontrado"
                ]);
            }
        } catch(\Exception $e) {
            // Make a Rollback
            DB::rollback();

            // Return Response
            return response()->json([
                "status" => 0,
                "message" => $e
            ]);
        }
    }

    public function delete(Request $request)
    {
        $id = $request->id;
        try{
            $salePoint = SalePoint::find($id);
            $salePoint->delete();
            return response()->json([
                "status" => 1,
                "message" => "Punto de Venta ". $salePoint->number . " eliminado exitosamente"
            ]);

        } catch (\Exception $e) {
            return response()->json([
                "status" => 0,
                "message" => "Ocurrio un error, intente mas tarde, si el problema persiste comuniquese con su administrador"
            ]);
        }
    }
}
