<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Takings;
use PDF;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\Turn;
use App\Models\PrepaidSummary;
use App\Models\PrepaidCard;
use App\Models\Profile;
use App\Models\Vehicle;
use App\Models\Ansapass;
use Illuminate\Support\Facades\DB;

class ReportController extends Controller
{

    public function diarySummaryReport(Request $request)
    {
        $beginDatetime = $request->beginDatetime;
        $endDatetime = $request->endDatetime;
        $turn = $request->turn;
        $typeVehicle = $request->typeVehicle;
        $method = $request->method;
        $data = $this->createDiarySummaryReport($beginDatetime, $endDatetime,$turn,$typeVehicle,$method);

        return response()->json($data);
    }

    public function printDiarySummaryReport(Request $request)
    {
        $beginDatetime = $request->beginDatetime;
        $endDatetime = $request->endDatetime;

        $data = $this->createDiarySummaryReport($beginDatetime, $endDatetime);

        $pdf = SnappyPDF::loadView('reports.turns.detailed', compact('data'));

        $pdf->setOption('enable-javascript', true);
        $pdf->setOption('no-stop-slow-scripts', true);
        $pdf->setOption('margin-bottom', 0);
        $pdf->setOption('margin-top', 0);
        $pdf->setOption('margin-left', 0);
        $pdf->setOption('margin-right', 0);
        $pdf->setOption('page-size', 'Letter');
        $pdf->setOption('lowquality', false);
        $pdf->setOption('disable-smart-shrinking', true);
        $pdf->setOption('images', true);
        $pdf->setOption('orientation', 'Landscape');
        $pdf->setOption('zoom', '0.68');
        $pdf->setOption('window-status', 'ready');
        $pdf->setTimeout(600);
        return $pdf->inline();
    }

    public function createDiarySummaryReport($beginDatetime, $endDatetime,$turn=false,$typeVehicle=false,$method=false)
    {
        $sql = "
            SELECT
                    `takings`.`code`,
                    `takings`.`vehicle_type_id`,
                    `payments`.`amount`,
                    `payments`.`payment_method_id`
            FROM
                `takings`,
                `paymentables`,
                `payments`
            WHERE `takings`.`created_at` BETWEEN '" . $beginDatetime . "' AND '" . $endDatetime . "'
            ";
        if($turn){
           $sql.="
                AND `takings`.`turn_id` = '" . $turn . "'"; 
        }
        if($method){
           $sql.="
                AND `payments`.`payment_method_id` = '" . $method . "'"; 
        }
        if($typeVehicle){
           $sql.="
                AND `takings`.`vehicle_type_id` = '" . $typeVehicle . "'"; 
        }
        $sql.="
            AND `takings`.`id` = `paymentables`.`paymentable_id`
            AND `paymentables`.`payment_id` = `payments`.`id`
            AND `paymentables`.`paymentable_type` LIKE '%Takings'
            AND `takings`.`deleted_at` IS NULL
            ORDER BY `takings`.`id` asc;
        ";
        $takings = DB::select($sql);

        $data = new \stdClass();

        $data->vehicleType = [];
        $data->vehicleTypeAmount = [];
        $data->paymentMethod = [];

        for ($i=1; $i < 10; $i++) {
            $data->vehicleType[$i] = 0;
            $data->vehicleTypeAmount[$i] = 0;
            $data->paymentMethod[$i]= 0;
            $data->mixPaymentMethod[$i] = 0;
        }

        $lastCode = null;
        foreach ($takings as $taking) {
            if($lastCode != $taking->code) {
                $data->vehicleType[$taking->vehicle_type_id]++;
            }
            $lastCode = $taking->code;

            $data->vehicleTypeAmount[$taking->vehicle_type_id] += floatval($taking->amount);
            $data->paymentMethod[$taking->payment_method_id] += floatval($taking->amount);
        }

        $data->totalVehicles = 0;
        $data->totalPayments = 0;
        $data->fromDate = $beginDatetime;
        $data->toDate = $endDatetime;

        foreach ($data->paymentMethod as $value) {
            $data->totalPayments += $value;
        }

        foreach ($data->vehicleType as $value) {
            $data->totalVehicles += $value;
        }

        return $data;
    }


    /**
     *
     *  TURN SUMMARY REPORTS
     *
     */

    public function recoverturnSummary(Request $request)
    {
        $id = $request->id;
        $turnData = $this->getTurnSumary($id);

        $data = new \stdClass();
        $data->totalOnlyCash = $turnData->paymentMethod[1];
        $data->totalOnlySalesPoint = $turnData->paymentMethod[2] + $turnData->paymentMethod[3];
        $data->totalOnlyBankOperation = $turnData->paymentMethod[4] + $turnData->paymentMethod[5];
        $data->totalOnlyPrepaid = $turnData->paymentMethod[6];
        $data->totalbs = $turnData->totalBs;

        return response()->json([
            "status" => 1,
            "message" => "Informacion Recuperada exitosamente",
            "data" => $data
        ]);
    }

    public function printWorkingDay(Request $request)
    {
        $ids = $request->ids;
        if(!count($ids)){
            return response()->json([
                "status" => 0,
                "message" => "Debes seleccionar al menos 1 turno"
            ]);
        }
        $turns = Turn::with('workstation', 'takings','volta')
                    ->whereIn('id', $ids)
                     ->withSum('volta', 'received')
                    ->orderBy('begin_at', 'desc')
                    ->get();

        $data = new \stdClass();
        $data->turns = [];
        $data->totalOnlyCash = 0;
        $data->totalOnlySalesPoint = 0;
        $data->totalOnlyBankOperation = 0;
        $data->totalOnlyPrepaid = 0;
        $data->totalbs = 0;
        $data->received = 0;

        foreach ($turns as $turn) {
            $turnData = $this->getTurnSumary($turn->id);
            array_push($data->turns, $turnData);
            $data->totalOnlyCash += $turnData->paymentMethod[1];
            $data->totalOnlySalesPoint += $turnData->paymentMethod[2] + $turnData->paymentMethod[3];
            $data->totalOnlyBankOperation += $turnData->paymentMethod[4] + $turnData->paymentMethod[5];
            $data->totalOnlyPrepaid += $turnData->paymentMethod[6];
            $data->totalbs += $turnData->totalBs;
            $data->received += floatval($turn->volta_sum_received);
        }
        try {
            
            $pdf = SnappyPDF::loadView('reports.turns.summary', compact('data'));

            $pdf->setOption('margin-bottom', 0);
            $pdf->setOption('margin-top', 0);
            $pdf->setOption('margin-left', 0);
            $pdf->setOption('margin-right', 0);
            $pdf->setOption('page-size', 'Letter');
            $pdf->setOption('lowquality', false);
            $pdf->setOption('disable-smart-shrinking', true);
            $pdf->setOption('zoom', '0.75');
            return $pdf->inline();
         } catch (Exception $e) {
            return $e->getMessage();
        }
    }

    private function getTurnSumary($id = null, $number = null)
    {
        // Object data will be the response of the function
        $data = new \stdClass();

        // recover the turn data info of the database
        $turn = Turn::with(['takings.payments', 'workstation', 'profile','volta']);
        if ($id) {
            $turn = $turn->where('id', $id)->first();
        } else if ($number) {
            $turn = $turn->where('number', $numBits)->first();
        }

        $now = date('Y-m-d H:i:s');

        // Start recover the info
        // BEGIN Static info
        $data->collector = $turn->profile->names .' '. $turn->profile->surnames;
        $data->workstation = $turn->workstation->name;
        $data->beginAt = $turn->begin_at;
        $data->endAt = $turn->end_at;
        $data->turnNumber = $turn->number;
        // END Static info

        // BEGIN Computed info
        // Vehicle types
        $data->vehicleType = [];
        $data->vehicleTypeAmount = [];
        $data->paymentMethod = [];
        $data->received = 0;
        $data->totalBs = 0;

        for ($i=1; $i < 10; $i++) {
            $data->vehicleType[$i] = 0;
            $data->vehicleTypeAmount[$i] = 0;
            $data->paymentMethod[$i]= 0;
        }

        foreach ($turn->takings as $taking) {
            $data->vehicleType[$taking->vehicle_type_id]++;
            $data->vehicleTypeAmount[$taking->vehicle_type_id] += floatval($taking->amount);
            $data->totalBs += floatval($taking->amount);

            foreach ($taking->payments as $payment) {
                $data->paymentMethod[$payment->payment_method_id] += floatval($payment->amount);
            }

        }
            foreach ($turn->volta as $volt) {
                $data->received += floatval($volt->received);
            }

        return $data;

        // END Computed info
    }

    /**
     *
     *  PREPAID SUMMARY REPORT
     *
     */

    public function getPrepaidSummaryReport(Request $request)
    {
        $rows = $this->recoverPrepaidSumaryReportFromRequest($request);
        return $rows;
    }

    public function printPrepaidSummaryReport(Request $request)
    {
        $rows = $this->recoverPrepaidSumaryReportFromRequest($request);

        $data = new \stdClass();
        $data->rows = $rows;
        $data->from = $request->beginDatetime;
        $data->to = $request->endDatetime;
        $data->credit = $request->credit;
        $data->debit = $request->debit;

        $profileId = $request->profileId ?? null;           // an user is selected?
        $prepaidCardId = $request->prepaidCardId ?? null;   // an prepaid card is selected?
        $vehicleId = $request->vehicleId ?? null;   // an prepaid card is selected?
        $ansapassId = $request->ansapassId ?? null;   // an ansapass is selected?

        if ($profileId) {
            $profile = Profile::find($profileId);
            $data->profileSelected = ($profile) ? $profile->names . " " . $profile->surnames : "Todos";
        }
        if ($prepaidCardId) {
            $card = PrepaidCard::find($prepaidCardId);
            $data->cardSelected = ($card) ? $card->code : "Todos";
        }
        if ($vehicleId) {
            $vehicle = Vehicle::find($vehicleId);
            $data->plateSelected = ($vehicle) ? $vehicle->plate : "Todos";
        }

        if ($ansapassId) {
            $ansapass = Ansapass::find($ansapassId);
            $data->ansapassSelected = ($ansapass) ? $ansapass->code : "Todos";
        }

        $pdf = SnappyPDF::loadView('reports.prepaids.list', compact('data'));
        $pdf->setOption('margin-bottom', 0);
        $pdf->setOption('margin-top', 0);
        $pdf->setOption('margin-left', 0);
        $pdf->setOption('margin-right', 0);
        $pdf->setOption('page-size', 'Letter');
        $pdf->setOption('lowquality', true);
        $pdf->setOption('disable-smart-shrinking', true);
        $pdf->setOption('images', true);
        $pdf->setOption('orientation', 'Landscape');
        $pdf->setOption('zoom', '0.85');
        $pdf->setTimeout(600);
        return $pdf->inline();
    }

    private function recoverPrepaidSumaryReportFromRequest(Request $request)
    {
        // Recover all parameters
        $beginDatetime = $request->beginDatetime;           // Begin Datetime for report
        $endDatetime = $request->endDatetime;               // End Datetime for report
        $debit = $request->debit;                           // All debits?
        $credit = $request->credit;                         // All credits?
        $profileId = $request->profileId ?? null;           // an user is selected?
        $prepaidCardId = $request->prepaidCardId ?? null;   // an prepaid card is selected?
        $vehicleId = $request->vehicleId ?? null;           // an prepaid card is selected?
        $ansapassId = $request->ansapassId ?? null;  
        $turn = $request->turn;
        $typeVehicle = $request->typeVehicle;
        $method = $request->method;


        $summary = PrepaidSummary::with(['ansapass.vehicle','prepaidCard.profile', 'payments.takings.turn.workstation', 'payments.takings.vehicle'])
                            ->whereBetween('prepaid_summaries.created_at', [$beginDatetime, $endDatetime]);


        // $summaries = $summary->get();
        // return $summaries;
        if($turn){
            $summary->whereHas('payments.takings', function ($query) use ($turn) {
                $query->where('turn_id', $turn);
            });
        }

        if($method){
            $summary->whereHas('payments', function ($query) use ($method) {
                $query->where('payment_method_id', $method);
            });
        }

        if($typeVehicle){
            $summary->whereHas('payments.takings', function ($query) use ($typeVehicle) {
                $query->where('vehicle_type_id', $typeVehicle);
            });
        }
        // If only debits are required
        if ($debit && !$credit) {
            $summary->where('type', 'out');
        }
        // If only credits are required
        if (!$debit && $credit) {
            $summary->where('type', 'add');
        }

        // ir a specific profile is required
        if ($profileId) {
            // recover all prepaid cards from this profile
            $cards = PrepaidCard::where('profile_id', $profileId)->get();
            // and prepare an array with all the card ids of this profile
            $cardIds = [];
            foreach ($cards as $card) {
                array_push($cardIds, $card->id);
            }
            // add the restrictions from this cards
            $summary->whereIn('prepaid_card_id', $cardIds);
        }

        // if a specific card is required
        if ($prepaidCardId) {
            // add the restriction from this specific card
            $summary->where('prepaid_card_id', $prepaidCardId);
        }

        // if a specific card is required
        if ($ansapassId) {
            // add the restriction from this specific card
            $summary->where('ansapass_id', $ansapassId);
        }

        // Recover all register after aply the restrictions

        // if a specific vehicle is required
        if ($vehicleId) {
            $summary->select('prepaid_summaries.*', 'takings.vehicle_id')
                    ->join('takings', 'prepaid_summaries.code', '=', 'takings.code')
                    ->where('takings.vehicle_id', $vehicleId);
        }

        $summary = $summary->orderBy('prepaid_summaries.created_at', 'asc')->get();
        //     // add the restriction from this specific card
        //     $filtered = $collection->filter(function ($value, $key) {
        //         return $value > 2;
        //     });
        //     $summary->where('ansapass_id', $ansapassId);
        // }

        $rows = [];

        foreach ($summary as $register) {
            // return $register;
            $row = new \stdClass();
            $row->id = $register->id;
            $date = date("d-m-Y", strtotime($register->created_at));
            $row->date = $date;
            $time = date("H:i:s", strtotime($register->created_at));
            $row->time = $time;

            $card = $register->prepaidCard;
            $row->cardCode = $card->code;

            $profile = $card->profile;
            $row->client = $profile->names . " " . $profile->surnames ?? "";

            $row->number = $register->code;
            $row->type = ($register->type == "add") ? "Credito" : "Debito";

            if (count($register->payments) && count($register->payments[0]->takings)) {
                $workstation =  $register->payments[0]->takings[0]->turn->workstation;
                $row->workstation = $workstation->description;
            } else {
                $row->workstation = "Oficina";
            }

            $row->concept = $register->concept;
            $row->cancel_concept = $register->cancel_concept;
            $row->ammount = ($register->type == "add") ? "" : "-";
            $row->ammount .= $register->amount;
            $row->new_balance = $register->new_balance;

            $row->plate = "No Disponible";
            if ($register->ansapass != null) {
                $row->plate = $register->ansapass->vehicle->plate;
                if ($register->ansapass->vehicle->profile_id != $profile->id) {
                    $row->errorPlate = true;
                }
            } elseif (!empty($register->payments)){
                $taking = $register->payments[0]->takings[0] ?? null;
                if($taking) {
                    $row->plate = ($taking->vehicle) ? $taking->vehicle->plate : "No Disponible";
                    if ($taking->vehicle){
                        if ($taking->vehicle->profile_id != $profile->id) {
                            $row->errorPlate = true;
                        }
                    }
                }
            }

            array_push($rows, $row);
        }

        return $rows;
    }
}
