<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PaymentMethod;

class PaymentMethodController extends Controller
{
    public function index(Request $request)
    {

        $user = $request->user();
        if (!$user) {
            return response()->json([
                "status" => 0,
                "message" => "Usuario no autenticado"
            ], 401);
        }

        $turn = $user->profile->turns()->latest()->first();

        if (!$turn && $user->profile->profile_type_id == 3) {
            return response()->json([
                "status" => 0,
                "message" => "Usuario no tiene turno activo"
            ], 403);
        }

        $methods = PaymentMethod::whereNotNull('id');

        if ($user->profile->profile_type_id == 3){
            if ($turn->workstation_id == 1) {
                $methods->whereIn('id', [1, 6,7]);
            }
        }

        return response()->json($methods->paginate());
    }

    public function delete(Request $request)
    {
        $id = $request->id;
        try{
            $method = PaymentMethod::find($id);
            $method->delete();
            return response()->json([
                "status" => 1,
                "message" => "Metodo de Pago ". $method->name . " eliminado exitosamente"
            ]);

        } catch (\Exception $e) {
            return response()->json([
                "status" => 0,
                "message" => "Ocurrio un error, intente mas tarde, si el problema persiste comuniquese con su administrador"
            ]);
        }
    }
}
