<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Takings;
use App\Models\Payment;
use App\Models\Profile;
use App\Models\PrepaidSummary;
use App\Traits\PaginatorHelper;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

class DashboardController extends Controller
{
    use PaginatorHelper;

    public function index(Request $request)
    {

        return response()->json(["carsProcesed"=>Takings::whereDate("created_at", Carbon::parse(date('Y-m-d'))->toDateString())->count(),
                                "payments"=>Payment::whereDate("created_at", Carbon::parse(date('Y-m-d'))->toDateString())->sum('amount'),
                                "paymentPre"=>Payment::where(array("payment_method_id"=>6))->whereDate("created_at", Carbon::parse(date('Y-m-d'))->toDateString())->sum('amount'),
                                "newUser"=>Profile::whereDate("created_at", Carbon::parse(date('Y-m-d'))->toDateString())->count(),
                                "sumMonth"=>Payment::whereMonth('created_at', Carbon::now()->month)->sum('amount'),
                                "sumBeforeMonth"=>Payment::whereMonth('created_at', Carbon::now()->subMonth())->sum('amount'),
                                "payByType"=>PrepaidSummary::whereMonth('created_at', Carbon::now()->month)
                                    ->selectRaw('CASE WHEN ansapass_id IS NULL THEN "Carnet Prepagados" ELSE "Ansapass" END AS groupType, COUNT(*) as total')
                                    ->groupByRaw('CASE WHEN ansapass_id IS NULL THEN "Carnet Prepagados" ELSE "Ansapass" END')
                                    ->get(),
                                "countByType"=>Takings::with(["vehicleType"])->whereDate('takings.created_at',  Carbon::parse(date('Y-m-d'))->toDateString())->groupBy('takings.vehicle_type_id')
                                    ->select('vehicle_type_id', \DB::raw('count(*) as total'))->get()
                                ]);

    }

}
