<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class TagReaded  implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    private $tag = null;
    private $workstation = null;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct($workstation, $tag)
    {
        $this->workstation = $workstation;
        $this->tag = $tag;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new Channel('workstation-'.$this->workstation->id);
    }

    public function broadcastAs()
    {
        return 'TagReaded';
    }

    public function broadcastWith()
    {
        return [
            "message" => "Ansapass Leido Correctamente",
            "workstation" => $this->workstation,
            "tag" => $this->tag
        ];
    }
}
