<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Cache;

class ProcessedAnsapass implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    private $tag = null;
    private $workstation = null;
    private $info = null;
    private $response = null;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct($workstation, $tag, $info)
    {
        $this->workstation = $workstation;
        $this->tag = $tag;
        $this->info = $info;
        $this->response = $this->generateResponse();

        // Save reponse in the cache
        Cache::put('lastAnsapassProcessed', $this->response);
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new Channel('workstation-1');
    }

    public function broadcastAs()
    {
        return 'ProcessedAnsapass';
    }

    public function broadcastWith()
    {
        return $this->response;
    }

    private function generateResponse()
    {
        $response = [
            "status" => 1,
            "message" => "Pago Procesado",
            "workstation" => $this->workstation,
            "tag" => $this->tag,
            "info" => $this->info,
        ];

        return $response;
    }
}
